<?php
if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

class UltimateAI_OpenAI_API_Manager extends UltimateAI_OpenAI_Args_Settings
{
  //private variable
  private $api_key;
  private $headers = array(
    "Content-Type"  => "application/json"
  );

  //END POINT
  private $chat_completion_api_url = "https://api.openai.com/v1/chat/completions";
  private $model_list_get_url = "https://api.openai.com/v1/models";
  private $image_generation_api_url = "https://api.openai.com/v1/images/generations";
  private $image_variation_api_url = "https://api.openai.com/v1/images/variations";
  private $speech_to_text_api_url = "https://api.openai.com/v1/audio/transcriptions";
  private $text_to_speech_api_url = "https://api.openai.com/v1/audio/speech";
  private $speech_to_translate_eng_api = "https://api.openai.com/v1/audio/translations";
  private $content_modaretion_api = "https://api.openai.com/v1/moderations";


  function __construct()
  {
    //get the api key from db and set it to $api_key variable;	
    $theme_settings_manager = new Ultimate_AI_Theme_Setting_Manager();
    $open_ai_settings = $theme_settings_manager->ultimate_ai_get_theme_settings(["uai_open_ai_settings"]);
    $this->api_key = $open_ai_settings["uai_open_ai_settings"]["open_ai_key"] ?? "";

    $user_manager = new Ultimate_AI_User_Manager();

    $check_access = $user_manager->check_user_integration_access('open_ai');
    if ($check_access['has_access']) {
      if (
        isset($check_access['settings']['is_active']) &&
        ($check_access['settings']['is_active'] == 'true' ||
          $check_access['settings']['is_active'] == true) &&
        !empty($check_access['settings']['api_key'])
      ) {
        $this->api_key = $check_access['settings']['api_key'];
      }
    }

    //set the Authorization Bearer in header
    $this->headers["Authorization"] = "Bearer " . $this->api_key;
  }

  public function is_res_streaming_enable()
  {
    $theme_settings_manager = new Ultimate_AI_Theme_Setting_Manager();
    $open_ai_settings = $theme_settings_manager->ultimate_ai_get_theme_settings(["uai_open_ai_settings"]);
    $is_stream_enable = $open_ai_settings["uai_open_ai_settings"]["is_streaming_enable"] ?? "true";

    return $is_stream_enable == "true";
  }


  private function remote_req_wrapper($url, $args, $method)
  {
    if ($method == "POST")  $responce = wp_remote_post($url, $args);
    if ($method == "GET")   $responce = wp_remote_get($url, $args);

    $res_status = wp_remote_retrieve_response_code($responce);

    if ($res_status == 200) {
      $type = wp_remote_retrieve_header($responce, 'content-type');

      return array(
        "status" => "success",
        "status_code" => $res_status,
        "data"  => $type == 'audio/mpeg' ? wp_remote_retrieve_body($responce) : json_decode(wp_remote_retrieve_body($responce))
      );
    }

    //if reach this line then res fail send fail responce
    return array("status" => "fail", "status_code" => $res_status, "full_res" => $responce);
  }

  private function set_body_to_req($body)
  {
    return array("headers" => $this->headers, "body" => $body, "timeout" => 60);
  }

  public function get_chat_completion_api_result($prompt, $model, $max_token)
  {
    $args = $this->set_body_to_req($this->args_generator_for_chat_api($prompt, $model, $max_token));
    return $this->remote_req_wrapper($this->chat_completion_api_url, $args, "POST");
  }

  public function get_chat_completion_api_result_as_stream($prompt, $model, $max_token, $concat_prev_chunk = true)
  {
    $ch = curl_init($this->chat_completion_api_url);
    $response_text = '';

    curl_setopt_array(
      $ch,
      array(
        CURLOPT_HTTPHEADER => array("Content-type: application/json", "Authorization: Bearer " . $this->api_key),
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $this->args_generator_for_chat_api($prompt, $model, $max_token, true),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_WRITEFUNCTION => function ($ch, $data) use (&$response_text, &$concat_prev_chunk) {
          $json = json_decode($data);

          if (isset($json->error)) {
            $error  = $json->error->message;
            $error .= " (" . $json->error->code . ")";
            $error  = "`" . trim($error) . "`";

            echo "data: " . json_encode(["content" => $error]) . "\n\n";

            echo "event: stop\n";
            echo "data: stopped\n\n";

            flush();
            die();
          }

          $deltas = explode("\n", $data);

          foreach ($deltas as $delta) {
            if (strpos($delta, "data: ") !== 0) {
              continue;
            }

            $json = json_decode(substr($delta, 6));

            if (isset($json->choices[0]->delta)) {
              $content = $json->choices[0]->delta->content ?? "";
            } elseif (trim($delta) == "data: [DONE]") {
              $content = "";
            } else {
              echo "event: stop\n";
              echo "data: stopped\n\n";
              flush();
              die();
            }

            if ($concat_prev_chunk) {
              $response_text .= $content;
            } else {
              $response_text = $content;
            }

            echo "data: " . json_encode(["content" => $response_text]) . "\n\n";
            flush();
          }

          if (connection_aborted()) return 0;

          return strlen($data);
        } //end writefn

      ) //end option array

    ); //end curl_setopt_array fn;

    $response = curl_exec($ch);

    return $response_text;
  }

  //$image_ulr is a url of the image and $prompt:string is what you want ai to tell you about the image
  public function get_vision_api_result($image_url, $prompt)
  {
    $model = "vision"; // check private $models on UltimateAI_OpenAI_Args_Settings class
    $_prompt = [
      [
        "role" => "user",
        "content" => [
          ["type" => "text", "text" => $prompt],
          ["type" => "image_url", "image_url" => ["url" => $image_url]]
        ]
      ]
    ];

    $args = $this->args_generator_for_chat_api($_prompt, $model, 1000, false);
    $args = $this->set_body_to_req($args);

    return $this->remote_req_wrapper($this->chat_completion_api_url, $args, "POST");
  }

  public function get_models()
  {
    $args = $this->set_body_to_req(array()); //this endpoint dont need any body
    return $this->remote_req_wrapper($this->model_list_get_url, $args, "GET");
  }

  public function get_image_generation_api_result($prompt, $image_size, $num_of_img, $over_write_args)
  {
    $args = $this->set_body_to_req($this->args_generator_for_image_generation_api($prompt, $image_size, $num_of_img, $over_write_args));
    return $this->remote_req_wrapper($this->image_generation_api_url, $args, "POST");
  }

  public function get_image_variations_api_result($image, $image_size, $num_of_img, $over_write_args)
  {
    $body = $this->args_generator_for_image_generation_api($image, $image_size, $num_of_img, $over_write_args, true);
    $body["image"] = new \CurlFile($image["tmp_name"], "image/png", $image["name"]);

    $ch = curl_init($this->image_variation_api_url);
    curl_setopt_array($ch, array(
      CURLOPT_HTTPHEADER => array("Content-type: multipart/form-data", "Authorization: Bearer " . $this->api_key),
      CURLOPT_POST => true,
      CURLOPT_POSTFIELDS => $body,
      CURLOPT_RETURNTRANSFER => true,
    ));

    $res = curl_exec($ch);
    if (!curl_errno($ch)) {
      return ["status" => "success", "status_code" => curl_getinfo($ch)["http_code"], "data" => json_decode($res)];
    }

    return ["status" => "fail", "status_code" => curl_getinfo($ch)["http_code"], "full_res" => $res];
  }

  public function get_speech_to_text_api_result($file, $prompt = "")
  {
    $args = $this->set_body_to_req($this->args_generator_for_speech_to_text_api(array("file" => $file, "prompt" => $prompt)));
    return $this->remote_req_wrapper($this->speech_to_text_api_url, $args, "POST");
  }

  public function get_text_to_speech_api_result($text, $voice, $model = 'tts-1')
  {
    $args = array(
      'headers' => [
        'Authorization' => 'Bearer ' . $this->api_key,
        'Content-Type' => 'application/json',
      ],
      'body' => json_encode([
        "model" => $model,
        "input" => $text,
        "voice" => $voice,
      ])
    );
    $res = $this->remote_req_wrapper($this->text_to_speech_api_url, $args, "POST");

    if ($res['status_code'] == 200) {
      // Save the body part to a variable
      $audio = $res['data'];

      $upload_dir = wp_upload_dir();
      $audio_dir = str_replace('/', DIRECTORY_SEPARATOR, $upload_dir['path']) . DIRECTORY_SEPARATOR;

      $unique_id = rand();
      // Create the name of the file 
      $file_name = 'ultiamate_ai_audio_' . $unique_id . '.mp3';

      //Save the file in the upload directory.
      $upload_file = file_put_contents($audio_dir . $file_name, $audio);
      if ($upload_file == false) {
        return false;
      }


      $attachment = array(
        'post_mime_type' => "audio/mpeg",
        'post_title'     => 'ultiamate_ai_audio_' . $unique_id,
        'post_content'   => '',
        'post_status'    => 'inherit',
        'guid'           => $file_name,
        "meta_input"     => array(
          "tool_type" => "ultimate_ai_audio",
        ),
      );

      $attach_id = wp_insert_attachment($attachment, $upload_dir['path'] . '/' . $file_name);

      return [
        'status' => 'success',
        'url' => wp_get_attachment_url($attach_id)
      ];
    } else {
      return [
        'status' => 'fail',
        'message' => esc_html__('Audio generation failed. Please check your API key is correct.', ULTIMATE_AI_SLUG),
        'res' => $res
      ];
    }
  }

  public function get_speech_to_eng_translate_api_result($file, $prompt)
  {
    $args = $this->args_generator_for_speech_to_text_api(array("file" => $file, "prompt" => $prompt));
    unset($args["language"]); //remove language. this endpoint dont need it.
    $req_args = $this->set_body_to_req($args);
    return $this->remote_req_wrapper($this->speech_to_translate_eng_api, $req_args, "POST");
  }

  public function get_modaretion_api_result($prompt)
  {
    $body = array("input" => $prompt); //default model for modaretion api is `text-moderation-latest`;
    $args = $this->set_body_to_req($body);
    return $this->remote_req_wrapper($this->content_modaretion_api, $args, "POST");
  }
}
